package org.mule.weave.v2.interpreted.extension

import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.option.ModuleOption
import org.mule.weave.v2.module.option.Settings
import org.mule.weave.v2.module.reader.ConfigurableDeferred
import org.mule.weave.v2.parser.exception.WeaveRuntimeException
import org.mule.weave.v2.parser.location.UnknownLocation

import scala.collection.mutable

class WeaveBasedDataFormatSettings(moduleOptions: Map[String, ModuleOption]) extends Settings {

  private val settings: mutable.Map[String, Any] = new mutable.HashMap()

  override def loadSettingsOptions(): Map[String, ModuleOption] = {
    moduleOptions ++ super.loadSettingsOptions()
  }

  override protected def writeSettingsValue(settingName: String, value: Any): Unit = {
    if (moduleOptions.contains(settingName)) {
      this.settings.put(settingName, value)
    } else {
      super.writeSettingsValue(settingName, value)
    }
  }

  def setting(settingsName: String): Option[Any] = {
    settings.get(settingsName)
  }

  def toObjectValue(): Value[ObjectSeq] = {
    val map = settings
      .mapValues({
        case s: String  => StringValue(s)
        case b: Boolean => BooleanValue(b)
        case i: Int     => NumberValue(i)
        case null       => NullValue
        case v          => throw new WeaveRuntimeException(s"`${String.valueOf(v)}` is not supported only String, Boolean and Number are supported", UnknownLocation)
      })
      .toMap
    ObjectValue(ObjectSeq(map))
  }
}

class WeaveBasedDataFormatWriterSettings(moduleOptions: Map[String, ModuleOption]) extends WeaveBasedDataFormatSettings(moduleOptions) with ConfigurableDeferred {}
