package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.DebuggerFrame
import org.mule.weave.v2.interpreted.listener.SessionListener
import org.mule.weave.v2.parser.location.WeaveLocation

trait WeaveDebuggingSession {

  /**
    * Marks this session as initialized
    */
  def initSession(): Unit

  /**
    * Adds a listener that will be notified when a client connects or if it is already initialiazed it will be called inmediatly
    * @param listener The listener
    */
  def addSessionListener(listener: SessionListener)

  /**
    * Callback method when execution is paused
    *
    * @param frames        The list of frames
    * @param weaveLocation The location
    */
  def onExecutionPaused(frames: Array[DebuggerFrame], weaveLocation: WeaveLocation, reason: Int)

  /**
    * Returns breakpoint manager
    *
    * @return
    */
  def getWeaveBreakpointManager(): WeaveBreakpointManager

  /**
    * The executor of this session
    *
    * @return
    */
  def getWeaveDebuggerExecutor(): WeaveDebuggerExecutor

  /**
    * If this session has been started or not
    *
    * @return
    */
  def started(): Boolean

  /**
    * Starts the session
    *
    * @param debuggerExecutor
    */
  def start(debuggerExecutor: WeaveDebuggerExecutor): Unit

  /**
    * Stops the session
    */
  def stop(): Unit

}
