package org.mule.weave.v2.interpreted

import org.mule.weave.v2.model.EvaluationContext

import java.io.File

/**
  * This trait is implemented by values that know how to dump itself
  */
trait DumpCapable {

  /**
    * Should dump the value in the specified folder
    * @param intoFolder The folder where this value needs to be dumped
    * @param ctx The context
    */
  def dumpValue(intoFolder: File)(implicit ctx: EvaluationContext): Unit

}
