package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.ast.structure.UriNode
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UriType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object UriTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    Some(UriType(Some(node.astNode.asInstanceOf[UriNode].literalValue)))
  }
}
