package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.ts.StringType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object StringTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    Some(StringType(Some(node.astNode.asInstanceOf[StringNode].literalValue)))
  }
}
