package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.StringType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object StringInterpolationTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    if (node.incomingEdges().size == 1) {
      node.incomingEdges().head.mayBeIncomingType()
    } else {
      Some(StringType())
    }
  }
}
