package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.scope.Reference
import org.mule.weave.v2.ts._

class NotEqTypeResolver(refLhs: Option[SourceReference], refRhs: Option[SourceReference]) extends EqTypeResolver(refLhs, refRhs) {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    super.resolveReturnType(node, ctx).map({
      case BooleanType(value, constraints) => BooleanType(value.map(!_), constraints.negate())
    })
  }
}
