package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.FunctionType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.ReferenceType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object DeconstructObjectPatternTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val caseExpression: Edge = node.incomingEdge(EdgeLabels.PATTERN_EXPRESSION).get
    val matchExpression: Edge = node.incomingEdge(EdgeLabels.MATCH_EXPRESSION).get
    val functionType: FunctionType = matchExpression.incomingType().asInstanceOf[FunctionType]
    val caseType: WeaveType = caseExpression.incomingType()

    resolveReturnType(node, ctx, functionType, caseType)
  }

  private def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext, functionType: FunctionType, caseType: WeaveType): Option[WeaveType] = {
    caseType match {
      case ObjectType(t, _, _) => {
        if (t.nonEmpty) {
          val headKvpType = t.head
          FunctionCallNodeResolver.resolveReturnType(functionType, Seq(headKvpType.key, headKvpType.value, caseType), Seq(), node, ctx)
        } else {
          None
        }
      }
      case rt: ReferenceType => resolveReturnType(node, ctx, functionType, rt.resolveType())
      case _                 => None
    }
  }
}
