package org.mule.weave.v2.ts

/**
  * This extension allows to have some custom type resolution for some "special" functions. This should be avoided but we realize this is necesary for some cases.
  * The problem with this is that we should push for a much powerful type system so this kind of magic is not necessary
  */
trait CustomTypeResolver {

  def appliesTo(params: Seq[FunctionTypeParameter], ctx: WeaveTypeResolutionContext) = true

  /**
    * Resolves the output type of an operation
    *
    * @param invocationTypes The types with which the operation is being invoked
    * @param ctx             The context
    * @return The inferred return type
    */
  def resolve(invocationTypes: Seq[WeaveType], ctx: WeaveTypeResolutionContext, node: TypeNode, resolvedReturnType: WeaveType): Option[WeaveType]
}
