package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeHelper.unify
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object AttributeSelectorCustomTypeResolver extends BaseValueSelectorCustomTypeResolver {

  /**
    * Attributes are considered to be Open, then all the same rules that are applied to Open Object selection should be applied here.
    */
  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    val maybeNameType = getSelectorNameType(selector)
    if (maybeNameType.isEmpty) {
      Unknown
    } else {
      val name = maybeNameType.get
      leftType.parentKey match {
        case Some(parentKey) => {
          val attrs = parentKey.attrs
          name.value match {
            case Some(_) => {
              attrs
                .find((attr) => TypeHelper.canBeAssignedTo(attr.name, name, ctx))
                .map((v) => {
                  Matched(v.value.cloneType().withOptional(v.optional))
                })
                .getOrElse(NoMatch(closed = false))
            }
            case None => {
              if (attrs.isEmpty) {
                NoMatch(closed = false)
              } else {
                val weaveType = unify(attrs.map(_.value)).markOptional()
                Matched(weaveType)
              }
            }
          }
        }
        case _ => Unknown
      }
    }
  }
}