package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.CustomTypeResolver
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.NullType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object AllAttributesSelectorCustomTypeResolver extends CustomTypeResolver {

  override def resolve(invocationTypes: Seq[WeaveType], ctx: WeaveTypeResolutionContext, node: TypeNode, resolvedReturnType: WeaveType): Option[WeaveType] = {
    val expression = invocationTypes.head
    expression match {
      case ArrayType(of) => {
        of match {
          case UnionType(seqWeaveTypes) => {
            val attributes: Seq[ObjectType] = seqWeaveTypes collect {
              case wt if wt.parentKey.isDefined && wt.parentKey.get.attrs.nonEmpty => {
                val types: Seq[KeyValuePairType] = wt.parentKey.get.attrs.map((nvp) => {
                  KeyValuePairType(KeyType(nvp.name), nvp.value)
                })
                ObjectType(types)
              }
            }
            if (attributes.nonEmpty) {
              if (attributes.size == 1)
                Some(ArrayType(attributes.head))
              else
                Some(ArrayType(UnionType(attributes)))
            } else {
              Some(ArrayType(ObjectType()))
            }
          }
          case a =>
            a.parentKey match {
              case Some(parentKey) => {
                if (parentKey.attrs.isEmpty) {
                  Some(ArrayType(ObjectType()))
                } else {
                  val types = parentKey.attrs.map((nvp) => {
                    KeyValuePairType(KeyType(nvp.name), nvp.value)
                  })
                  Some(ArrayType(ObjectType(types)))
                }
              }
              case _ => {
                Some(ArrayType(ObjectType()))
              }
            }
        }
      }
      case _ => {
        expression.parentKey match {
          case Some(parentKey) => {
            if (parentKey.attrs.isEmpty) {
              Some(UnionType(Seq(ObjectType(), NullType())))
            } else {
              val types = parentKey.attrs.map((nvp) => {
                KeyValuePairType(KeyType(nvp.name), nvp.value)
              })
              Some(ObjectType(types))
            }
          }
          case _ => {
            Some(UnionType(Seq(ObjectType(), NullType())))
          }
        }
      }
    }
  }

}