package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.FunctionIsNotTailRecCapable
import org.mule.weave.v2.parser.annotation.TailRecFunctionAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.VarDirective

class TailRecValidatorAnnotationProcessor extends AbstractScopeAnnotationProcessor {

  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ScopePhaseAnnotationContext): Unit = {
    annotatedNode match {
      case fpn: FunctionDirectiveNode => {
        val mayBeAnnotation = fpn.variable.annotation(classOf[TailRecFunctionAnnotation])
        mayBeAnnotation match {
          case None => {
            context.messageCollector.error(FunctionIsNotTailRecCapable(fpn.variable), fpn.variable.location())
          }
          case _ =>
        }
      }
      case fpn: VarDirective => {
        val mayBeAnnotation = fpn.variable.annotation(classOf[TailRecFunctionAnnotation])
        mayBeAnnotation match {
          case None => {
            context.messageCollector.error(FunctionIsNotTailRecCapable(fpn.variable), fpn.variable.location())
          }
          case _ =>
        }
      }
      case _ =>
    }
  }
}
