package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.ContentType
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective
import org.mule.weave.v2.parser.ast.structure.DocumentNode

class ImplicitOutputTransformer extends AstNodeTransformer {
  override def transform(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case DocumentNode(header, root) => {
        //If no output directive is present add the implicit output if defined
        if (!header.directives.exists(_.isInstanceOf[OutputDirective])) {
          context.implicitOutputMimeType.foreach((mimeType) => {
            val outputDirective: OutputDirective = OutputDirective(ContentType(mimeType), None, None)
            outputDirective.annotate(InjectedNodeAnnotation())
            header.directives = outputDirective +: header.directives
          })
        }
      }
      case _ =>
    }
  }
}
