package org.mule.weave.v2.parser.phase
import org.mule.weave.v2.grammar.EqOpId
import org.mule.weave.v2.parser.InvalidEqualComparison
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.ts.TypeGraph
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

/**
  * Checks if when comparing two types with == it is allways going to return false
  * @tparam R Return type
  * @tparam T
  */
class EqualityTypeChecker[R <: AstNode, T <: TypeCheckingResult[R]]() extends VerificationPhase[T] {
  override def verify(source: T, context: ParsingContext): Unit = {
    val astNode: R = source.astNode
    val typeGraph: TypeGraph = source.typeGraph
    val typeResolutionContext = new WeaveTypeResolutionContext(typeGraph)

    AstNodeHelper.traverseChildren(
      astNode, {
      case bon: BinaryOpNode if (bon.opId == EqOpId) => {

        val maybeLeftType = typeGraph.findNode(bon.lhs).flatMap(_.resultType())
        val maybeRightType = typeGraph.findNode(bon.rhs).flatMap(_.resultType())
        if (maybeLeftType.isDefined && maybeRightType.isDefined) {
          val leftType = maybeLeftType.get
          val rightType = maybeRightType.get
          if (TypeHelper(context).areDisjointTypes(leftType, rightType)) {
            context.messageCollector.warning(InvalidEqualComparison(leftType, rightType, typeResolutionContext), bon.location())
          }
        }
        true
      }
      case _ => true
    })
  }
}
