package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser._
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.scope.ScopesNavigator
import org.mule.weave.v2.ts._

/**
  * Validates that the parameters of the annotation are valid with the valid type
  */
class AnnotationParameterValidation[R <: AstNode, T <: TypeCheckingResult[R]] extends VerificationPhase[T] {

  override def verify(source: T, context: ParsingContext): Unit = {
    val scopeNavigator: ScopesNavigator = source.scope
    val annotationNodes: Seq[AnnotationNode] = scopeNavigator.astNavigator().allWithType(classOf[AnnotationNode])
    annotationNodes.foreach(an => {
      val maybeReference = scopeNavigator.resolveVariable(an.name)
      maybeReference match {
        case Some(ref) => {
          val typeReferenceResolver = new ScopeGraphTypeReferenceResolver(ref.scope.rootScope().scopesNavigator())
          val maybeAnnotationDirectiveNode = ref.scope.astNavigator().parentWithType(ref.referencedNode, classOf[AnnotationDirectiveNode])
          maybeAnnotationDirectiveNode match {
            case Some(adn) => {
              val expectedParams = adn.params.paramList
              val mayBeArgs = an.args
              val argsLength = mayBeArgs.map(_.args.length).getOrElse(0)
              if (expectedParams.length == argsLength) {
                mayBeArgs.foreach((args) => {
                  args.args.foreach((arg) => {
                    val argName = arg.name
                    val mayBeParam = expectedParams.find(_.nameIdentifier.name == argName.name)
                    mayBeParam match {
                      case Some(param) => {
                        val paramType = WeaveType(param.weaveType, typeReferenceResolver)
                        source.typeGraph.findNode(arg.value).flatMap(_.resultType()) match {
                          case Some(argType) => {
                            val reasons = MessageCollector()
                            val isValidParameter = TypeHelper.canBeAssignedTo(argType, paramType, null, messageCollector = reasons)
                            if (!isValidParameter) {
                              reasons.errorMessages.foreach((pair) => {
                                context.messageCollector.error(pair._2, pair._1)
                              })
                            }
                          }
                          case _ => //TODO unable to infer type ???
                        }
                      }
                      case None => {
                        context.messageCollector.error(InvalidArgumentName(argName, expectedParams.map(_.nameIdentifier.name)), arg.name.location())
                      }
                    }
                  })
                })
              } else {
                context.messageCollector.error(InvalidAmountOfAnnotationArguments(expectedParams.length, argsLength), an.location())
              }
            }
            case None => {
              context.messageCollector.error(InvalidAnnotationReference(an.name), an.location())
            }
          }
        }
        case None => {
          //This was already validated
        }
      }
    })
  }
}
