package org.mule.weave.v2.parser.location

import org.mule.weave.v2.parser.SafeStringBasedParserInput
import org.parboiled2.ParserInput

import scala.annotation.tailrec

abstract class ParserPosition(index: Int) extends Position

case class SimpleParserPosition(index: Int, line: Int, column: Int, source: () => String) extends ParserPosition(index)

case class IndexedParserPosition(index: Int, input: SafeStringBasedParserInput) extends ParserPosition(index) {
  private lazy val lc: (Int, Int) = getLineAndColumn()

  override def line: Int = lc._1

  override def column: Int = lc._2

  override def source: () => String = () => input.getLine(line)

  def getLineAndColumn(): (Int, Int) = {
    input.getLineAndColumn(index)
  }

}

object ParserPosition {
  def apply(idx: Int, input: SafeStringBasedParserInput): ParserPosition = {
    IndexedParserPosition(idx, input)
  }

  def apply(pos: org.parboiled2.Position, input: SafeStringBasedParserInput): ParserPosition = {
    SimpleParserPosition(pos.index - 1, pos.line, pos.column, () => input.getLine(pos.line))
  }
}

object UnknownPosition extends Position {
  override def index: Int = 0

  override def column: Int = 0

  override def source: () => String = () => ""

  override def line: Int = 0
}
