package org.mule.weave.v2.parser.ast.variables

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class VariableReferenceNode(var variable: NameIdentifier, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {

  override def children(): Seq[AstNode] = Children(variable).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = copy(variable.cloneAst(), codeAnnotations.map(_.cloneAst()))

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.VARIABLE_REFERENCE_NODE
}

object VariableReferenceNode {
  def apply(name: String): VariableReferenceNode = VariableReferenceNode(NameIdentifier(name))
}
