package org.mule.weave.v2.parser.ast.structure.schema

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child

case class SchemaPropertyNode(name: AstNode, value: AstNode, condition: Option[AstNode]) extends AstNode {

  override def cloneAst(): SchemaPropertyNode = super.cloneAst().asInstanceOf[SchemaPropertyNode]

  override def children(): Seq[AstNode] = Child(name, value, condition)

  override protected def doClone(): AstNode = {
    copy(name.cloneAst(), value.cloneAst(), condition.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.SCHEMA_PROPERTY_NODE
}

case class SchemaNode(var properties: Seq[SchemaPropertyNode]) extends AstNode {
  override def children(): Seq[AstNode] = properties

  override protected def doClone(): AstNode = {
    copy(properties.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.SCHEMA_NODE
}

object TimeUnit {
  val MILLISECONDS = "milliseconds"
  val SECONDS = "seconds"
  val HOURS = "hours"
  val MINUTES = "minutes"
  val NANOS = "nanos"
  val DAYS = "days"
  val MONTHS = "months"
  val YEARS = "years"
}
