package org.mule.weave.v2.parser.ast.patterns

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ContainerAstNode
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class PatternExpressionsNode(var patterns: Seq[PatternExpressionNode]) extends ContainerAstNode {
  override def children(): Seq[AstNode] = patterns

  override def cloneAst(): PatternExpressionsNode = super.cloneAst().asInstanceOf[PatternExpressionsNode]

  override protected def doClone(): AstNode = {
    copy(patterns.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.EXPRESSIONS_PATTERN_NODE
}

case class PatternMatcherNode(var lhs: AstNode, var patterns: PatternExpressionsNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {
  override def children(): Seq[AstNode] = Children(lhs, patterns).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(lhs.cloneAst(), patterns.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.PATTERN_MATCHER_NODE
}
