package org.mule.weave.v2.parser.ast.patterns

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

sealed trait PatternExpressionNode extends AstNode {

  /**
    * The node to be executed when the expression matches
    *
    * @return the ast node
    */
  def onMatch: AstNode

  override def cloneAst(): PatternExpressionNode = super.cloneAst().asInstanceOf[PatternExpressionNode]
}

case class RegexPatternNode(var pattern: AstNode, name: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(pattern, name, onMatch)
  override protected def doClone(): AstNode = copy(pattern.cloneAst(), name.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.REGEX_PATTERN_NODE
}

case class TypePatternNode(var pattern: AstNode, name: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(pattern, name, onMatch)
  override protected def doClone(): AstNode = copy(pattern.cloneAst(), name.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.TYPE_PATTERN_NODE
}

case class LiteralPatternNode(var pattern: AstNode, name: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(pattern, name, onMatch)
  override protected def doClone(): AstNode = copy(pattern.cloneAst(), name.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.LITERAL_PATTERN_NODE
}

case class ExpressionPatternNode(var pattern: AstNode, name: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(pattern, name, onMatch)

  override protected def doClone(): AstNode = copy(pattern.cloneAst(), name.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.EXPRESSION_PATTERN_NODE
}

case class EmptyArrayPatternNode(var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(onMatch)

  override protected def doClone(): AstNode = copy(onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.EMPTY_ARRAY_PATTERN_NODE
}

case class DeconstructArrayPatternNode(head: NameIdentifier, tail: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(head, tail, onMatch)

  override protected def doClone(): AstNode = copy(head.cloneAst(), tail.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.DECONSTRUCT_ARRAY_PATTERN_NODE
}

case class EmptyObjectPatternNode(var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(onMatch)

  override protected def doClone(): AstNode = copy(onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.EMPTY_OBJECT_PATTERN_NODE
}

case class DeconstructObjectPatternNode(headKey: NameIdentifier, headValue: NameIdentifier, tail: NameIdentifier, var onMatch: AstNode) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(headKey, headValue, tail, onMatch)

  override protected def doClone(): AstNode = copy(headKey.cloneAst(), headValue.cloneAst(), tail.cloneAst(), onMatch.cloneAst())

  override def getKind(): String = DWAstNodeKind.DECONSTRUCT_OBJECT_PATTERN_NODE
}

case class DefaultPatternNode(var onMatch: AstNode, name: NameIdentifier) extends PatternExpressionNode {
  override def children(): Seq[AstNode] = Child(onMatch, name)

  override protected def doClone(): AstNode = copy(onMatch.cloneAst(), name.cloneAst())

  override def getKind(): String = DWAstNodeKind.DEFAULT_PATTERN_NODE
}
