package org.mule.weave.v2.parser.ast.logical

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class OrNode(lhs: AstNode, rhs: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {
  override def children(): Seq[AstNode] = Children(lhs, rhs).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(lhs.cloneAst(), rhs.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.OR_NODE
}
