package org.mule.weave.v2.parser.ast.header

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.ContainerAstNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective

case class HeaderNode(var directives: Seq[DirectiveNode]) extends ContainerAstNode {

  def addDirectiveAfter(newDirective: DirectiveNode, after: DirectiveNode): Unit = {
    if (after == null) {
      directives = newDirective +: directives
    } else {
      val index = directives.splitAt(directives.indexOf(after) + 1)
      directives = index._1 ++ Seq(newDirective) ++ index._2
    }
  }

  override def children(): Seq[AstNode] = directives

  override def cloneAst(): HeaderNode = super.cloneAst().asInstanceOf[HeaderNode]

  override protected def doClone(): AstNode = copy(directives.map(_.cloneAst()))

  override def getKind(): String = DWAstNodeKind.HEADER_NODE
}

object HeaderNode {
  def emptyHeader(): HeaderNode = {
    val headerNode = new HeaderNode(Seq())
    headerNode.annotate(InjectedNodeAnnotation())
    headerNode
  }

  def withVersion(): HeaderNode = {
    val directive = new VersionDirective()
    directive.annotate(InjectedNodeAnnotation())
    new HeaderNode(List(directive))
  }
}
