package org.mule.weave.v2.mapping
import org.mule.weave.v2.ts.WeaveType

/**
  * An arrow mapping is a simple value assignment (from a source to a target)
  */
case class FieldAssignment(source: NamePathElement, target: NamePathElement, sourceType: Option[WeaveType] = None, targetType: Option[WeaveType] = None) {
  override def equals(obj: scala.Any): Boolean = {
    if (super.equals(obj)) {
      return true
    }

    obj match {
      case x: FieldAssignment =>
        source.toString == x.source.toString &&
          target.toString == x.target.toString
      case _ =>
        false
    }
  }

  override def hashCode(): Int = {
    val code = 31 * source.toString.hashCode + target.toString.hashCode
    code
  }

  override def toString: String = "\"" + s"$source -> $target" + "\""
}

object FieldAssignment {
  def apply(sourceStr: String, targetStr: String): FieldAssignment = {
    new FieldAssignment(NamePathElement.fromString(sourceStr), NamePathElement.fromString(targetStr))
  }

  def apply(sourceStr: String, targetStr: String, sourceType: Option[WeaveType], targetType: Option[WeaveType]): FieldAssignment = {
    new FieldAssignment(NamePathElement.fromString(sourceStr), NamePathElement.fromString(targetStr), sourceType, targetType)
  }
}

