package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.structure.RegexNode
import org.parboiled2._

trait RegexLiteral extends PositionTracking with Tokens with StringBuilding {
  this: RegexLiteral with Grammar =>

  val createRegexNode = (regex: String) => {
    new RegexNode(regex)
  }

  def regexLiteral: Rule1[RegexNode] = namedRule("Regex") {
    atomic(pushPosition ~ (regexStart ~!~ clearSB() ~ oneOrMore(("\\/" | noneOf("/")) ~ appendSB()) ~!~ regexEnd ~ push(sb.toString) ~> createRegexNode) ~ injectPosition)
  }
}
