package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.structure.NumberNode
import org.parboiled2.CharPredicate.{ Digit, Digit19 }
import org.parboiled2._
import org.parboiled2.support.hlist.HNil

trait IntegerLiteral extends PositionTracking with Tokens with StringBuilding {
  this: IntegerLiteral with Parser =>

  val createNumberNode: (String) => NumberNode = (n: String) => {
    NumberNode(n)
  }

  def number: Rule1[NumberNode] = namedRule("Number") {
    atomic(pushPosition ~ (capture(integer ~ optional(frac) ~ optional(exp)) ~> createNumberNode) ~ injectPosition)
  }

  private def frac = rule {
    ch('.') ~ digits
  }

  private def exp = rule {
    ignoreCase('e') ~ optional(anyOf("+-")) ~ digits
  }

  def integerLiteral: Rule1[NumberNode] = namedRule("Integer") {
    atomic(pushPosition ~ (capture(integer) ~> createNumberNode) ~ injectPosition)
  }

  def integer: Rule[HNil, HNil] = rule {
    optional(ch('-')) ~ (Digit19 ~ digits | Digit)
  }

  def digits: Rule[HNil, HNil] = rule {
    oneOrMore(Digit)
  }
}
