package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.structure.BooleanNode
import org.parboiled2._

trait BooleanLiteral extends PositionTracking with Tokens with StringBuilding {
  this: BooleanLiteral with Grammar =>

  def booleanLiteral: Rule1[BooleanNode] = namedRule("Boolean") { atomic(trueLiteral | falseLiteral) }

  def trueLiteral: Rule1[BooleanNode] = namedRule("true") { atomic(pushPosition ~ (trueKeyword ~ push(BooleanNode("true"))) ~ injectPosition) }

  def falseLiteral: Rule1[BooleanNode] = namedRule("false") { atomic(pushPosition ~ (falseKeyword ~ push(BooleanNode("false"))) ~ injectPosition) }
}
