package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.ErrorRecovery
import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.parboiled2._

trait BaseExpression extends StringBuilding {
  this: BaseExpression with Grammar with ErrorRecovery =>

  def expr: Rule1[AstNode]

  def enclosedExpr: Rule1[AstNode]

  val createNameNode: (Seq[AnnotationNode], Option[NamespaceNode], AstNode) => NameNode = (annotations: Seq[AnnotationNode], ns: Option[NamespaceNode], keyName: AstNode) => {
    NameNode(keyName, ns, annotations)
  }

  val createNameNodeWithoutAnnotations: (Option[NamespaceNode], AstNode) => NameNode = (ns: Option[NamespaceNode], keyName: AstNode) => {
    NameNode(keyName, ns)
  }

  def fieldName: Rule1[NameNode] = namedRule("FieldName") {
    atomic(pushPosition ~ atomic(annotations ~ ws ~ namespace ~ (nameString | string | invalidFieldNameDeclaration) ~> createNameNode) ~ injectPosition)
  }

  def fieldNameWithoutAnnotations: Rule1[NameNode] = namedRule("FieldName") {
    atomic(pushPosition ~ atomic(namespace ~ (nameString | string | invalidFieldNameDeclaration) ~> createNameNodeWithoutAnnotations) ~ injectPosition)
  }

  def ifCondition: Rule1[AstNode] = namedRule("Enclosed Expression") {
    parenStart ~!~ (expr | missingExpression("Missing If Condition Expression")) ~ (parenEnd | fail("')' for if condition."))
  }
}
