package org.mule.weave.v2.grammar

import org.mule.weave.v2.utils.DataWeaveVersion
import org.parboiled2.{ Parser, Rule0 }

trait VersionControl {
  this: VersionControl with Parser with WhiteSpaceHandling with Directives =>

  def since(dwVersion: String): Rule0 = {
    val s = dwVersion.split('.')
    val version = DataWeaveVersion(s(0).toInt, s(1).toInt)
    documentSyntaxVersion match {
      case Some(runTimeVersion) => rule { test(runTimeVersion >= version) }
      case None                 => rule { MISMATCH }
    }
  }

  def upTo(dwVersion: String): Rule0 = {
    val s = dwVersion.split('.')
    val version = DataWeaveVersion(s(0).toInt, s(1).toInt)
    documentSyntaxVersion match {
      case Some(runTimeVersion) => rule { test(runTimeVersion <= version) }
      case None                 => rule { MISMATCH }
    }
  }

  def before(dwVersion: String): Rule0 = {
    val s = dwVersion.split('.')
    val version = DataWeaveVersion(s(0).toInt, s(1).toInt)
    documentSyntaxVersion match {
      case Some(runTimeVersion) => rule { test(runTimeVersion < version) }
      case None                 => rule { MISMATCH }
    }
  }

  def after(dwVersion: String): Rule0 = {
    val s = dwVersion.split('.')
    val version = DataWeaveVersion(s(0).toInt, s(1).toInt)
    documentSyntaxVersion match {
      case Some(runTimeVersion) => rule { test(runTimeVersion > version) }
      case None                 => rule { MISMATCH }
    }
  }
}