package org.mule.weave.v2.grammar

import org.mule.weave.v2.grammar.literals.Literals
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.grammar.structure.Array
import org.mule.weave.v2.grammar.structure.Object
import org.mule.weave.v2.parser.annotation.SingleKeyValuePairNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode
import org.mule.weave.v2.parser.ast.structure.ObjectNode
import org.parboiled2._

trait Values extends PositionTracking
    with Literals
    with Tokens
    with Object
    with Variables
    with Array
    with Selectors {
  this: Values with Grammar =>

  def value: Rule1[AstNode] = rule {
    (lambdaLiteral | singleKeyValuePairObj | atomic(variable ~ optional(ws ~ customInterpolation)) | literal | multipleKeyValuePairObj | array | parentBasedExpr) ~ optional(ws ~ functionCall) ~ optional(selectors)
  }

  def parentBasedExpr = rule {
    enclosedExpr ~ optional(
      singleDynamicKeyValuePairObject |
        conditionalSingleKeyValuePairObject)
  }

  def conditionalSingleKeyValuePairObject = rule {
    (test(isSingleKeyValuePair(valueStack.peek)) ~ ws ~ ifKeyword ~!~ ((ws ~ ifCondition) | (fws ~ expr)) ~> createConditionalSingleKeyValuePairObject) ~ injectBinaryPosition
  }

  def singleDynamicKeyValuePairObject = rule {
    (dynamicKeyExpr ~!~ expr ~> createDynamicSingleKeyValuePairObject) ~ injectBinaryPosition
  }

  def isSingleKeyValuePair(node: Any): Boolean = {
    node match {
      case on: ObjectNode if on.annotation(classOf[SingleKeyValuePairNodeAnnotation]).isDefined => true
      case _ => false
    }
  }

  protected val createConditionalSingleKeyValuePairObject = (expr: AstNode, condition: AstNode) => {
    val objectNode = expr.asInstanceOf[ObjectNode]
    val keyValuePairNode = objectNode.elements.head.asInstanceOf[KeyValuePairNode]
    val node = createConditionalKeyValuePairNode(keyValuePairNode.key, keyValuePairNode.value, condition)
    createSingleKeyValueObjectNode(doInjectBinaryPosition(node))
  }

  protected val createDynamicSingleKeyValuePairObject = (keyNode: AstNode, value: AstNode) => {
    val keyValuePairNode = createKeyValuePairNode(keyNode, value)

    createSingleKeyValueObjectNode(doInjectBinaryPosition(keyValuePairNode))
  }
}
