package org.mule.weave.v2.editor

import org.mule.weave.v2.completion.Template

/**
  * Represents an editor document. This api is being used by the quickfix to introduce changes
  */
trait WeaveTextDocument {

  /**
    * Runs the template at the specified offset
    *
    * @param template The template to execute
    * @param location The location where to run it
    */
  def runTemplate(template: Template, location: Int): Unit

  /**
    * Inserts a text at the specified location
    *
    * @param text     The text to insert
    * @param location The location
    */
  def insert(text: String, location: Int): Unit

  /**
    * Deletes the text in the document in between the specified offsets
    *
    * @param startLocation The start location
    * @param endLocation   The end location
    * @return
    */
  def delete(startLocation: Int, endLocation: Int): Unit

  /**
    * Returns the text in between the specified offsets
    *
    * @param startLocation The start location
    * @param endLocation   The end location
    * @return
    */
  def text(startLocation: Int, endLocation: Int): String

  /**
    * Replaces the text in the given range with the new text
    *
    * @param startLocation The start location of the range
    * @param endLocation   The end location of the range
    * @param newText       The new text
    */
  def replace(startLocation: Int, endLocation: Int, newText: String): Unit = {
    delete(startLocation, endLocation)
    insert(newText, startLocation)
  }

}
