package org.mule.weave.v2.editor

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.location.WeaveLocation

case class ValidationMessages(errorMessage: Array[ValidationMessage], warningMessage: Array[ValidationMessage]) {
  def concat(messages: ValidationMessages): ValidationMessages = {
    ValidationMessages(errorMessage ++ messages.errorMessage, warningMessage ++ messages.warningMessage)
  }
}

case class ValidationMessage(location: WeaveLocation, message: Message, quickFix: Array[QuickFix] = Array())

case class QuickFix(name: String, description: String, quickFix: QuickFixAction)
