package org.mule.weave.v2.metadata.api

import org.mule.metadata.api.model.MetadataFormat
import org.mule.metadata.api.model.MetadataType
import org.mule.weave.v2.parser.ast
import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.StringType
import org.mule.weave.v2.ts.TimeZoneType
import org.mule.weave.v2.ts.WeaveType

object MuleTypesConverter {
  def toMuleType(
    wtype: WeaveType,
    format: MetadataFormat,
    sample: Option[String] = None,
    mimeTypeProperties: Map[String, String] = Map(),
    skipUnionsAsEnums: Boolean = false,
    weaveTypeMetadataConvert: Option[WeaveTypeMetadataConvert] = None): MetadataType = {
    val config = MetadataModelConverterConfig(
      structuralIdentity = true,
      skipUnionsAsEnums = skipUnionsAsEnums,
      skipLiterals = true,
      simplifyIntersection = true,
      useReferenceTypes = false,
      weaveTypeMetadataConvert = weaveTypeMetadataConvert)
    new MetadataModelConverter(config).toMuleType(wtype, format, sample, mimeTypeProperties)
  }

  def toMuleType(wtype: WeaveType): MetadataType = {
    val config = MetadataModelConverterConfig(
      structuralIdentity = true,
      simplifyIntersection = true,
      skipLiterals = true,
      useReferenceTypes = false)
    new MetadataModelConverter(config).toMuleType(wtype)
  }

  def getFormat(wtype: WeaveType): Option[MetadataFormat] = {
    val config = MetadataModelConverterConfig(
      structuralIdentity = true,
      simplifyIntersection = true,
      skipLiterals = true,
      useReferenceTypes = false)
    new MetadataModelConverter(config).getFormat(wtype)
  }

  def errorVariable(): ObjectType = {
    ObjectType(
      Seq(
        KeyValuePairType(KeyType(NameType(Some(ast.QName("description")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("detailedDescription")))), StringType()),
        KeyValuePairType(
          KeyType(NameType(Some(ast.QName("errorType")))),
          ObjectType(Seq(
            KeyValuePairType(KeyType(NameType(Some(ast.QName("identifier")))), StringType()),
            KeyValuePairType(KeyType(NameType(Some(ast.QName("namespace")))), StringType()))))))
  }

  def appVariable(): ObjectType = {
    ObjectType(
      Seq(
        KeyValuePairType(KeyType(NameType(Some(ast.QName("name")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("encoding")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("workDir")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("registry")))), ObjectType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("standalone")))), BooleanType())))
  }

  def serverVariable(): ObjectType = {
    ObjectType(
      Seq(
        KeyValuePairType(KeyType(NameType(Some(ast.QName("host")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("ip")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("timeZone")))), TimeZoneType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("tmpDir")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("fileSeparator")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("osName")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("osArch")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("javaVersion")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("javaVendor")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("userName")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("userHome")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("userDir")))), StringType())))
  }

  def muleVariable(): ObjectType = {
    ObjectType(
      Seq(
        KeyValuePairType(KeyType(NameType(Some(ast.QName("host")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("clusterId")))), StringType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("nodeId")))), TimeZoneType()),
        KeyValuePairType(KeyType(NameType(Some(ast.QName("home")))), StringType())))
  }
}
