package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.module.commons.java.writer.ClassSchemaNode
import org.mule.weave.v2.module.commons.java.writer.ClassTypeWithRestriction
import org.mule.weave.v2.module.commons.java.writer.JavaAdapter
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.parser.location.LocationCapable

import java.util
import java.util.Optional

class OptionalEntry(override val location: LocationCapable, component: ClassTypeWithRestriction)(implicit val converter: BaseJavaDataConverter) extends WriterEntry {

  var optional: util.Optional[Any] = Optional.empty()

  def write(value: Any) {
    optional = if (value != null) Optional.of(JavaAdapter.fromScalaToJava(value)) else Optional.empty()
  }

  override def entryType(): Class[_] = component.classValue.getOrElse(classOf[Object])

  override def contentTypeSchema(): Option[ClassSchemaNode] = component.constrainClassSchema

  override def resolveEntryValue(): Any = optional
}
