package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.module.commons.java.writer.JavaAdapter
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

import java.lang.reflect.Method

class BuilderPropertyEntry(override val location: LocationCapable, name: String, container: Any, builderProxy: BuilderProxyDefinition) extends WriterEntry {

  override implicit val converter: BaseJavaDataConverter = JavaDataConverter

  lazy val method: Method = builderProxy.getPropertyMethod(name, location)

  override def write(value: Any): Unit = {
    method.invoke(container, JavaAdapter.fromScalaToJava(value).asInstanceOf[Object])
  }

  override def resolveEntryValue(): Any = {
    container
  }

  override def entryType(): Class[_] = method.getParameterTypes.apply(0)
}
