package org.mule.weave.v2.module.java

import org.mule.weave.v2.core.env.WeaveRuntime

object ValueToJavaAdaptorManager {

  private lazy val valueAdapters = {
    WeaveRuntime.getServiceProvider().serviceImplementations(classOf[ValueToJavaAdapter])
  }

  def findAdapterForClass(expectedJavaType: Class[_]): Option[ValueToJavaAdapter] = {
    valueAdapters.find(_.handles(expectedJavaType))
  }

}
