package org.mule.weave.v2.module.java

import java.lang.reflect.Method

object MethodOrderingByName extends Ordering[Method] {
  override def compare(x: Method, y: Method): Int = {
    x.getName.compareTo(y.getName)
  }
}

object MethodOrdering extends Ordering[Method] {

  /**
    * Returns an integer whose sign communicates how x Method compares to y Method.
    * Order sequence:
    * 1- method name
    * 2- parameters count
    * 3- parameter type name
    */
  override def compare(x: Method, y: Method): Int = {
    // 1- Compare method name
    var comparison = x.getName.compareTo(y.getName)
    if (comparison == 0) {
      val leftParameterTypes = x.getParameterTypes
      val rightParameterTypes = y.getParameterTypes
      // 2- Compare method parameter count
      if (leftParameterTypes.length < rightParameterTypes.length) {
        comparison = -1
      } else if (leftParameterTypes.length > rightParameterTypes.length) {
        comparison = 1
      } else {
        var found = false
        var index = 0
        while (index < leftParameterTypes.length && !found) {
          val leftParameterType = leftParameterTypes(index)
          val rightParameterType = rightParameterTypes(index)
          // 3- Compare parameters type name
          val comparisonParameterType = leftParameterType.getName.compareTo(rightParameterType.getName)
          if (comparisonParameterType != 0) {
            comparison = comparisonParameterType
            found = true
          }
          index = index + 1
        }
      }
    }
    comparison
  }
}
