package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.ClassSchemaNode
import org.mule.weave.v2.module.commons.java.writer.ClassTypeWithRestriction
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

import java.util

class IteratorEntry(override val location: LocationCapable, override val schemaOption: Option[Schema], component: ClassTypeWithRestriction) extends WriterEntry {

  override implicit val converter: BaseJavaDataConverter = JavaDataConverter

  val container = new util.ArrayList[Any]()

  def write(value: Any) {
    container.add(value)
  }

  override def entryType(): Class[_] = component.classValue.getOrElse(classOf[Object])

  override def contentTypeSchema(): Option[ClassSchemaNode] = component.constrainClassSchema

  override def resolveEntryValue(): Any = container.iterator()
}
