package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.values.KeyValue
import org.mule.weave.v2.module.commons.java.value.JavaLocation
import org.mule.weave.v2.parser.location.Location

class JavaStringKeyValue(name: String, val locationString: () => String) extends KeyValue {
  lazy val kv = QualifiedName(name, None)

  override def evaluate(implicit ctx: EvaluationContext): this.type#T = kv

  override def location(): Location = new JavaLocation(locationString())
}
