package org.mule.weave.v2.module.pojo.reader

import java.util
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaLocation
import org.mule.weave.v2.module.commons.java.value.JavaSchema
import org.mule.weave.v2.module.pojo.writer.JavaTypes

class JavaIteratorArrayValue(iterator: util.Iterator[_], val locationString: () => String)(implicit ctx: EvaluationContext) extends JavaArrayValue {

  lazy val value = ArraySeq(new JavaIteratorWrapper(iterator, locationString))

  override def evaluate(implicit ctx: EvaluationContext): T = value

  override def underlying()(implicit ctx: EvaluationContext): Any = iterator

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    Some(JavaSchema(underlying().getClass, JavaTypes.iterator_propertySeq))
  }
}

class JavaIteratorWrapper(iterator: util.Iterator[_], loc: () => String)(implicit ctx: EvaluationContext) extends Iterator[Value[_]] {
  var currentIndex: Int = -1
  var currentValue: Value[_] = _

  override def next(): Value[_] = {
    currentIndex += 1
    currentValue = ReflectionJavaValueConverter.convert(iterator.next(), JavaLocation.indexAccess(loc, currentIndex))
    currentValue
  }

  override def hasNext: Boolean = iterator.hasNext

}
