package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaLocation
import org.mule.weave.v2.module.commons.java.value.JavaValue
import org.mule.weave.v2.module.pojo.JavaDataFormat
import org.mule.weave.v2.module.pojo.writer.JavaWriter
import org.mule.weave.v2.module.writer.WriterHelper
import org.mule.weave.v2.parser.location.Location

class JavaFunctionValue(fn: java.util.function.Function[Any, Any], val locationString: () => String) extends UnaryFunctionValue with JavaValue[Any] {
  override val R = ArrayType

  override def doExecute(v: ArrayType.V)(implicit ctx: EvaluationContext): Value[_] = {
    import scala.collection.JavaConverters._
    val args = v.evaluate.toSeq()
    val javaArgs = args.map(arg => {
      val javaWriter: JavaWriter = JavaDataFormat.defaultSettingsWriter(None)
      WriterHelper.writeValue(javaWriter, arg, arg)
      javaWriter.result
    })
    val result = fn.apply(javaArgs.asJava)
    ReflectionJavaValueConverter.convert(result, locationString)
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = fn

  override def location(): Location = new JavaLocation(locationString())
}
