package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter.CalendarDataConverter$

import java.util.Calendar
import java.util.GregorianCalendar
import javax.xml.datatype.DatatypeFactory
import javax.xml.datatype.XMLGregorianCalendar

class XmlGregorianCalendarDataConverter extends DataConverter[XMLGregorianCalendar] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[XMLGregorianCalendar] = {
    source match {
      case x: XMLGregorianCalendar => Some(x)
      case _ => {
        val mayBeCalendar: Option[Calendar] = CalendarDataConverter$.convert(source, schema)
        if (mayBeCalendar.isDefined) {
          val value = mayBeCalendar.get
          value match {
            case calendar: GregorianCalendar =>
              Option(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar))
            case _ =>
              None
          }
        } else {
          None
        }
      }
    }

  }
}
