package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class NumberConverter extends DataConverter[java.lang.Number] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[java.lang.Number] = {
    source match {
      case n: Number if n.isWhole => {
        if (n.canBeInt) Some(n.toInt)
        else if (n.canBeLong) Some(n.toLong)
        else Some(n.toBigInt.bigInteger)
      }
      case n: Number => {
        if (n.withinDouble) Some(n.toDouble)
        else Some(n.toBigDecimal.bigDecimal)
      }
      case str: String => convert(Number(str), schema)
      case _           => None
    }
  }
}
