package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class DoubleDataConverter extends DataConverter[Double] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Double] = {
    source match {
      case l: Long                  => Option(l.toDouble)
      case i: Int                   => Option(i.toDouble)
      case d: Double                => Option(d)
      case d: Float                 => Option(d.toDouble)
      case s: Short                 => Option(s.toDouble)
      case n: Number                => Option(n.toDouble)
      case bd: java.math.BigDecimal => Option(bd.doubleValue())
      case bi: java.math.BigInteger => Option(bi.doubleValue())
      case str: String              => Option(str.toDouble)
      case _                        => None
    }

  }
}
