package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

class CharDataConverter extends DataConverter[Char] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Char] = {
    source match {
      case ch: Char    => Option(ch)
      case str: String => if (str.nonEmpty) Option(str.charAt(0)) else None
      case _           => None
    }

  }
}
