package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.nio.ByteBuffer

class ByteBufferDataConverter extends DataConverter[ByteBuffer] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[ByteBuffer] = {
    val byteArrayConverter = new ByteArrayDataConverter
    byteArrayConverter.convert(source, schema).map(ByteBuffer.wrap)
  }
}
