package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

class BooleanDataConverter extends DataConverter[Boolean] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Boolean] = {
    source match {
      case b: Boolean  => Option(b)
      case str: String => Option(str.toBoolean)
      case _           => None
    }
  }
}
