package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.TimeValue

import java.time.OffsetTime

trait JavaTimeValue extends TimeValue with JavaValue[OffsetTime] {

}

object JavaTimeValue {
  def apply(value: OffsetTime, locationString: () => String): JavaTimeValue = new JavaTimeTimeValue(value, locationString)
}

class JavaTimeTimeValue(value: OffsetTime, val locationString: () => String) extends JavaTimeValue {
  override def underlying()(implicit ctx: EvaluationContext): Any = value

  override def evaluate(implicit ctx: EvaluationContext): T = value
}

