/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.indexed;

import java.io.DataInputStream;
import java.nio.charset.Charset;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenArray;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryParserInput;
import org.mule.weave.v2.module.dwb.reader.indexed.WeaveBinaryValue$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class BinaryValueRetriever$ {
    public static BinaryValueRetriever$ MODULE$;
    private final Charset charset;

    static {
        new BinaryValueRetriever$();
    }

    private Charset charset() {
        return this.charset;
    }

    public String readShortString(DataInputStream input) {
        int length = input.readUnsignedShort();
        return this.readString(input, length);
    }

    public String readShortString(DataInputStream input, byte[] buffer) {
        int length = input.readUnsignedShort();
        return this.readString(input, length, buffer);
    }

    public String readString(DataInputStream input, int length) {
        byte[] buffer = new byte[length];
        return this.readString(input, length, buffer);
    }

    public String readString(DataInputStream input, int length, byte[] buffer) {
        input.readFully(buffer, 0, length);
        return new String(buffer, 0, length, this.charset());
    }

    public KeyValue readKey(long keyTokenIndex, long[] keyToken, BinaryParserInput input) {
        int tokenType;
        String name = WeaveBinaryValue$.MODULE$.readLocalName(input, keyToken);
        int n = tokenType = DwTokenHelper$.MODULE$.getTokenType(keyToken);
        if (DwTokenType$.MODULE$.Key() == n) {
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            return KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        }
        if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            Namespace namespace = this.readNamespace(keyToken, input);
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            return KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        }
        if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes(keyTokenIndex, input);
            return KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        }
        if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            Namespace namespace = this.readNamespace(keyToken, input);
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes(keyTokenIndex, input);
            return KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Got '").append(DwTokenType$.MODULE$.getNameFor(tokenType)).append("' token while reading keys").toString());
    }

    public Namespace readNamespace(long[] token, BinaryParserInput input) {
        Option<Object> nsIndexMaybe = DwTokenHelper$.MODULE$.getNsIndex(token);
        Namespace namespace = (Namespace)input.namespaces().apply(BoxesRunTime.unboxToInt((Object)nsIndexMaybe.get()));
        return namespace;
    }

    public Value<NameSeq> readAttributes(long keyTokenIndex, BinaryParserInput input) {
        TokenArray tokenArray = input.tokenArray();
        long[] keyToken = tokenArray.apply(keyTokenIndex);
        long offset = DwTokenHelper$.MODULE$.getOffset(keyToken);
        input.seekableStream().seek(offset);
        ArrayBuffer attrPairs = new ArrayBuffer();
        DataInputStream dis = input.dataInputStream();
        int attrCount = dis.readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            long pairPos = keyTokenIndex + (long)(i * 2);
            String nameStr = WeaveBinaryValue$.MODULE$.readLocalName(input, tokenArray.apply(pairPos + 1L));
            KeyValue key = KeyValue$.MODULE$.apply(nameStr);
            Value<?> value = WeaveBinaryValue$.MODULE$.apply(pairPos + 2L, (Option<Object>)None$.MODULE$, input);
            attrPairs.$plus$eq((Object)new NameValuePair((Value)key, value));
        }
        return AttributesValue$.MODULE$.apply((Seq)attrPairs);
    }

    private BinaryValueRetriever$() {
        MODULE$ = this;
        this.charset = Charset.forName("UTF-8");
    }
}

