/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.indexed;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.core.common.LocationCacheBuilder;
import org.mule.weave.v2.module.core.common.TokenHelper;
import org.mule.weave.v2.module.core.xml.reader.indexed.LocationCaches;
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenArray;
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenArray$;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.WeaveBinaryUtils$;
import org.mule.weave.v2.module.dwb.WeaveKeyToken$;
import org.mule.weave.v2.module.dwb.WeaveValueToken$;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryParser;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryParserInput;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.dwb.reader.indexed.WeaveBinaryValue$;
import org.mule.weave.v2.module.dwb.reader.indexed.ZoneIdMap;
import org.mule.weave.v2.module.dwb.reader.indexed.ZoneOffsetMap;
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriter$;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.ILongArray;
import org.mule.weave.v2.module.reader.SeekableStreamSourceReader$;
import org.mule.weave.v2.module.reader.SourceReader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u001e<\u00011C\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\tI\u0002\u0011\t\u0011)A\u00053\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005o\u0001\t\u0005\t\u0015a\u0003p\u0011\u0015)\b\u0001\"\u0001w\u0011\u001di\bA1A\u0005\nyDaa \u0001!\u0002\u00131\u0007\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u0015\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t9\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\t9\u0004\u0001Q\u0001\n\u00055\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\tI\u0006\u0001Q\u0001\n\u0005u\u0002\"CA.\u0001\t\u0007I\u0011BA/\u0011!\t\t\u0007\u0001Q\u0001\n\u0005}\u0003\"CA2\u0001\t\u0007I\u0011BA3\u0011!\ti\u0007\u0001Q\u0001\n\u0005\u001d\u0004\"CA8\u0001\t\u0007I\u0011BA9\u0011!\tI\b\u0001Q\u0001\n\u0005M\u0004\"CA>\u0001\t\u0007I\u0011BA?\u0011!\ti\t\u0001Q\u0001\n\u0005}\u0004bCAH\u0001\u0001\u0007\t\u0019!C\u0001\u0003#C1\"a)\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002&\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0005\u000b\u0015BAJ\u0011-\t\u0019\f\u0001a\u0001\u0002\u0004%\t!!.\t\u0017\u0005u\u0006\u00011AA\u0002\u0013\u0005\u0011q\u0018\u0005\f\u0003\u0007\u0004\u0001\u0019!A!B\u0013\t9\fC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002H\"I\u0011q\u001a\u0001A\u0002\u0013%\u0011\u0011\u001b\u0005\t\u0003+\u0004\u0001\u0015)\u0003\u0002J\"Y\u0011q\u001b\u0001A\u0002\u0003\u0007I\u0011BAm\u0011-\t\t\u000f\u0001a\u0001\u0002\u0004%I!a9\t\u0017\u0005\u001d\b\u00011A\u0001B\u0003&\u00111\u001c\u0005\b\u0003S\u0004A\u0011AAv\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a>\u0001\t\u0003\tI\u0010C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\t]\u0002\u0001\"\u0001\u0002l\"9!\u0011\b\u0001\u0005\u0002\u0005-\bb\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqAa#\u0001\t\u0003\u0011i\tC\u0004\u0003\u0010\u0002!I!a;\t\u000f\tE\u0005\u0001\"\u0001\u0002l\"9!Q\u000b\u0001\u0005\n\tM\u0005b\u0002BL\u0001\u0011%!Q\u0012\u0005\b\u00053\u0003A\u0011\u0002BG\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;CqAa(\u0001\t\u0003\u0011i\nC\u0004\u0003\"\u0002!\tAa)\t\u000f\t\u0015\u0006\u0001\"\u0003\u0003(\"9!Q\u0016\u0001\u0005\u0002\u0005-\bb\u0002BX\u0001\u0011\u0005!\u0011\u0017\u0005\b\u0005o\u0003A\u0011\u0001B]\u0005aIe\u000eZ3yK\u0012<V-\u0019<f\u0005&t\u0017M]=QCJ\u001cXM\u001d\u0006\u0003yu\nq!\u001b8eKb,GM\u0003\u0002?\u007f\u00051!/Z1eKJT!\u0001Q!\u0002\u0007\u0011<(M\u0003\u0002C\u0007\u00061Qn\u001c3vY\u0016T!\u0001R#\u0002\u0005Y\u0014$B\u0001$H\u0003\u00159X-\u0019<f\u0015\tA\u0015*\u0001\u0003nk2,'\"\u0001&\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i5\u000b\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0004B]f\u0014VM\u001a\t\u0003)Vk\u0011!P\u0005\u0003-v\u0012\u0011cV3bm\u0016\u0014\u0015N\\1ssB\u000b'o]3s\u0003\u0011q\u0017-\\3\u0016\u0003e\u0003\"AW1\u000f\u0005m{\u0006C\u0001/P\u001b\u0005i&B\u00010L\u0003\u0019a$o\\8u}%\u0011\u0001mT\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002a\u001f\u0006)a.Y7fA\u0005\u00111o\u001d\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f!![8\u000b\u0005-\u001c\u0015\u0001B2pe\u0016L!!\u001c5\u0003\u001dM+Wm[1cY\u0016\u001cFO]3b[\u0006\u00191\r\u001e=\u0011\u0005A\u001cX\"A9\u000b\u0005I\u001c\u0015!B7pI\u0016d\u0017B\u0001;r\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]\\H\u0010\u0006\u0002yuB\u0011\u0011\u0010A\u0007\u0002w!)a.\u0002a\u0002_\")q+\u0002a\u00013\")Q-\u0002a\u0001M\u0006q1/Z3lC\ndWm\u0015;sK\u0006lW#\u00014\u0002\u001fM,Wm[1cY\u0016\u001cFO]3b[\u0002\nqa\u00195beN,G/\u0006\u0002\u0002\u0006A!\u0011qAA\n\u001b\t\tIA\u0003\u0003\u0002\u0002\u0005-!\u0002BA\u0007\u0003\u001f\t1A\\5p\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0013\u0011qa\u00115beN,G/\u0001\u0005dQ\u0006\u00148/\u001a;!\u0003=!\u0017\r^1J]B,Ho\u0015;sK\u0006lWCAA\u000f!\u0011\ty\"a\t\u000e\u0005\u0005\u0005\"bA5\u0002\u0010%!\u0011QEA\u0011\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017\u0001\u00053bi\u0006Le\u000e];u'R\u0014X-Y7!\u00031\u0019x.\u001e:dKJ+\u0017\rZ3s+\t\ti\u0003\u0005\u0003\u00020\u0005MRBAA\u0019\u0015\tq\u0014)\u0003\u0003\u00026\u0005E\"\u0001D*pkJ\u001cWMU3bI\u0016\u0014\u0018!D:pkJ\u001cWMU3bI\u0016\u0014\b%\u0001\u0006oC6,7\u000f]1dKN,\"!!\u0010\u0011\r\u0005}\u0012\u0011JA'\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000fz\u0015AC2pY2,7\r^5p]&!\u00111JA!\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015r\u0003%\u0019HO];diV\u0014X-\u0003\u0003\u0002X\u0005E#!\u0003(b[\u0016\u001c\b/Y2f\u0003-q\u0017-\\3ta\u0006\u001cWm\u001d\u0011\u0002\u000b9\fW.Z:\u0016\u0005\u0005}\u0003#BA \u0003\u0013J\u0016A\u00028b[\u0016\u001c\b%A\u0004{_:,\u0017\nZ:\u0016\u0005\u0005\u001d\u0004cA=\u0002j%\u0019\u00111N\u001e\u0003\u0013i{g.Z%e\u001b\u0006\u0004\u0018\u0001\u0003>p]\u0016LEm\u001d\u0011\u0002\u0017i|g.Z(gMN,Go]\u000b\u0003\u0003g\u00022!_A;\u0013\r\t9h\u000f\u0002\u000e5>tWm\u00144gg\u0016$X*\u00199\u0002\u0019i|g.Z(gMN,Go\u001d\u0011\u0002\u00131\u001c')^5mI\u0016\u0014XCAA@!\u0011\t\t)!#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000baaY8n[>t'BA6B\u0013\u0011\tY)a!\u0003)1{7-\u0019;j_:\u001c\u0015m\u00195f\u0005VLG\u000eZ3s\u0003)a7MQ;jY\u0012,'\u000fI\u0001\u000bi>\\WM\\!se\u0006LXCAAJ!\u0011\t)*a(\u000e\u0005\u0005]%b\u0001\u001f\u0002\u001a*\u0019a(a'\u000b\t\u0005u\u0015qQ\u0001\u0004q6d\u0017\u0002BAQ\u0003/\u0013!\u0002V8lK:\f%O]1z\u00039!xn[3o\u0003J\u0014\u0018-_0%KF$B!a*\u0002.B\u0019a*!+\n\u0007\u0005-vJ\u0001\u0003V]&$\b\"CAX3\u0005\u0005\t\u0019AAJ\u0003\rAH%M\u0001\fi>\\WM\\!se\u0006L\b%\u0001\bm_\u000e\fG/[8o\u0007\u0006\u001c\u0007.Z:\u0016\u0005\u0005]\u0006\u0003BAK\u0003sKA!a/\u0002\u0018\nqAj\\2bi&|gnQ1dQ\u0016\u001c\u0018A\u00057pG\u0006$\u0018n\u001c8DC\u000eDWm]0%KF$B!a*\u0002B\"I\u0011q\u0016\u000f\u0002\u0002\u0003\u0007\u0011qW\u0001\u0010Y>\u001c\u0017\r^5p]\u000e\u000b7\r[3tA\u0005)A-\u001a9uQV\u0011\u0011\u0011\u001a\t\u0004\u001d\u0006-\u0017bAAg\u001f\n\u0019\u0011J\u001c;\u0002\u0013\u0011,\u0007\u000f\u001e5`I\u0015\fH\u0003BAT\u0003'D\u0011\"a, \u0003\u0003\u0005\r!!3\u0002\r\u0011,\u0007\u000f\u001e5!\u0003!A\u0017m]%oI\u0016DXCAAn!\rq\u0015Q\\\u0005\u0004\u0003?|%a\u0002\"p_2,\u0017M\\\u0001\rQ\u0006\u001c\u0018J\u001c3fq~#S-\u001d\u000b\u0005\u0003O\u000b)\u000fC\u0005\u00020\n\n\t\u00111\u0001\u0002\\\u0006I\u0001.Y:J]\u0012,\u0007\u0010I\u0001\u0006G2|7/\u001a\u000b\u0003\u0003O\u000b\u0001bZ3u\u0013:\u0004X\u000f\u001e\u000b\u0003\u0003c\u00042!_Az\u0013\r\t)p\u000f\u0002\u0012\u0005&t\u0017M]=QCJ\u001cXM]%oaV$\u0018\u0001C1eIR{7.\u001a8\u0015\r\u0005\u001d\u00161 B\u0006\u0011\u001d\tiP\na\u0001\u0003\u007f\fQ\u0001^8lK:\u0004RA\u0014B\u0001\u0005\u000bI1Aa\u0001P\u0005\u0015\t%O]1z!\rq%qA\u0005\u0004\u0005\u0013y%\u0001\u0002'p]\u001eDqA!\u0004'\u0001\u0004\tY.\u0001\u0007qkR$vn[3o\u0013:d5)A\u0003qCJ\u001cX\r\u0006\u0002\u0003\u0014A\"!Q\u0003B\u0013!\u0019\u00119B!\b\u0003\"5\u0011!\u0011\u0004\u0006\u0004\u00057\t\u0018A\u0002<bYV,7/\u0003\u0003\u0003 \te!!\u0002,bYV,\u0007\u0003\u0002B\u0012\u0005Ka\u0001\u0001B\u0006\u0003(\u001d\n\t\u0011!A\u0003\u0002\t%\"aA0%cE!!1\u0006B\u0019!\rq%QF\u0005\u0004\u0005_y%a\u0002(pi\"Lgn\u001a\t\u0004\u001d\nM\u0012b\u0001B\u001b\u001f\n\u0019\u0011I\\=\u0002\u0015I,\u0017\r\u001a%fC\u0012,'/\u0001\u0006m_\u0006$7)Y2iKN\fA\u0002\u001d:pG\u0016\u001c8OV1mk\u0016$b!a*\u0003@\t\r\u0003b\u0002B!U\u0001\u0007\u0011\u0011Z\u0001\u0013i>\\WM\u001c+za\u0016<\u0016\u000e\u001e5GY\u0006<7\u000fC\u0004\u0003\u000e)\u0002\r!a7\u0002\u001d\r\u0014X-\u0019;f\u0017\u0016LHk\\6f]RQ\u0011q B%\u0005\u0017\u0012yEa\u0015\t\u000b][\u0003\u0019A-\t\u000f\t53\u00061\u0001\u0002J\u0006Ia.Y7f\u0013:$W\r\u001f\u0005\b\u0005#Z\u0003\u0019AAe\u0003\u001dq7/\u00138eKbDqA!\u0016,\u0001\u0004\u00119&A\u0005u_.,g\u000eV=qKB!!\u0011\fB<\u001d\u0011\u0011YFa\u001d\u000f\t\tu#\u0011\u000f\b\u0005\u0005?\u0012yG\u0004\u0003\u0003b\t5d\u0002\u0002B2\u0005WrAA!\u001a\u0003j9\u0019ALa\u001a\n\u0003)K!\u0001S%\n\u0005\u0019;\u0015B\u0001#F\u0013\t\u00115)\u0003\u0002A\u0003&\u0019!QO \u0002\u0017\u0011;Hk\\6f]RK\b/Z\u0005\u0005\u0005s\u0012YHA\u0006EoR{7.\u001a8UsB,'b\u0001B;\u007f\u0005\u00012M]3bi\u00164\u0016\r\\;f)>\\WM\u001c\u000b\t\u0003\u007f\u0014\tI!\"\u0003\b\"9!1\u0011\u0017A\u0002\t\u0015\u0011A\u00027f]\u001e$\b\u000eC\u0004\u0003V1\u0002\rAa\u0016\t\u000f\t%E\u00061\u0001\u0002\\\u0006I\u0001.Y:TG\",W.Y\u0001\u000ee\u0016\fG\rV8lK:$\u0016\u0010]3\u0015\u0005\u0005%\u0017A\u0004:fC\u0012\fE\u000f\u001e:jEV$Xm]\u0001\u000be\u0016\fGmU2iK6\fG\u0003BAe\u0005+CqA!\u00111\u0001\u0004\tI-A\u0005sK\u0006$\u0017I\u001d:bs\u0006Q!/Z1e\u001f\nTWm\u0019;\u0002\u001fI,\u0017\rZ*i_J$8\u000b\u001e:j]\u001e$\u0012!W\u0001\u0014e\u0016\fGMT1nK\u0012+7\r\\1sCRLwN\\\u0001\u0012e\u0016\fGMT*EK\u000ed\u0017M]1uS>tGCAA'\u0003%\u00198.\u001b9CsR,7\u000f\u0006\u0003\u0002(\n%\u0006b\u0002BVm\u0001\u0007\u0011\u0011Z\u0001\u0002]\u0006Q!/Z1e\u0007\u0006\u001c\u0007.Z:\u0002)I,\u0017\rZ$m_\n\fG\u000eV8lK:Le\u000eZ3y)\u0011\t\u0019Ja-\t\u000f\tU\u0006\b1\u0001\u0003\u0006\u0005\u0001Bo\\6f]NduN\\4t\u0007>,h\u000e^\u0001\u0013e\u0016\fG\rT8dCRLwN\\\"bG\",7\u000f\u0006\u0002\u00028\u0002")
public class IndexedWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream ss;
    private final EvaluationContext ctx;
    private final SeekableStream seekableStream;
    private final Charset charset;
    private final DataInputStream dataInputStream;
    private final SourceReader sourceReader;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final ZoneIdMap zoneIds;
    private final ZoneOffsetMap zoneOffsets;
    private final LocationCacheBuilder lcBuilder;
    private TokenArray tokenArray;
    private LocationCaches locationCaches;
    private int depth;
    private boolean hasIndex;
    private final int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    private final byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    @Override
    public boolean verifyIndexPresence(DataInputStream dataInputStream) {
        return WeaveBinaryParser.verifyIndexPresence$(this, dataInputStream);
    }

    @Override
    public byte[] getReadBuffer() {
        return WeaveBinaryParser.getReadBuffer$(this);
    }

    @Override
    public byte[] getReadBuffer(int length) {
        return WeaveBinaryParser.getReadBuffer$(this, length);
    }

    @Override
    public int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    }

    @Override
    public byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize_$eq(int x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize = x$1;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer_$eq(byte[] x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer = x$1;
    }

    public String name() {
        return this.name;
    }

    private SeekableStream seekableStream() {
        return this.seekableStream;
    }

    private Charset charset() {
        return this.charset;
    }

    private DataInputStream dataInputStream() {
        return this.dataInputStream;
    }

    private SourceReader sourceReader() {
        return this.sourceReader;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private ZoneIdMap zoneIds() {
        return this.zoneIds;
    }

    private ZoneOffsetMap zoneOffsets() {
        return this.zoneOffsets;
    }

    private LocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public TokenArray tokenArray() {
        return this.tokenArray;
    }

    public void tokenArray_$eq(TokenArray x$1) {
        this.tokenArray = x$1;
    }

    public LocationCaches locationCaches() {
        return this.locationCaches;
    }

    public void locationCaches_$eq(LocationCaches x$1) {
        this.locationCaches = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private boolean hasIndex() {
        return this.hasIndex;
    }

    private void hasIndex_$eq(boolean x$1) {
        this.hasIndex = x$1;
    }

    public void close() {
        this.dataInputStream().close();
        this.sourceReader().close();
    }

    public BinaryParserInput getInput() {
        return new BinaryParserInput(this.ss, this.seekableStream(), this.dataInputStream(), this.sourceReader(), this.locationCaches(), this.tokenArray(), this.namespaces(), this.names(), this.zoneIds(), this.zoneOffsets(), this.ctx);
    }

    public void addToken(long[] token, boolean putTokenInLC) {
        block0: {
            this.tokenArray().$plus$eq(token);
            if (!putTokenInLC) break block0;
            this.lcBuilder().addToken(token, this.tokenArray().length() - 1L);
        }
    }

    @Override
    public Value<?> parse() {
        this.readHeader();
        if (this.hasIndex()) {
            this.readCaches();
        } else {
            this.loadCaches();
        }
        return WeaveBinaryValue$.MODULE$.apply(0L, (Option<Object>)None$.MODULE$, this.getInput());
    }

    public void readHeader() {
        this.verifyMagicWord(this.dataInputStream());
        this.verifyVersion(this.dataInputStream());
        this.hasIndex_$eq(this.verifyIndexPresence(this.dataInputStream()));
    }

    public void loadCaches() {
        if (this.tokenArray() != null) {
            return;
        }
        this.tokenArray_$eq((TokenArray)this.ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), this.ctx)));
        int nextValueType = this.readTokenType();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        this.processValue(nextValueType, true);
        this.locationCaches_$eq((LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.lcBuilder().build()));
        this.seekableStream().seek((long)WeaveBinaryWriter$.MODULE$.HEADER_BYTES());
    }

    public void processValue(int tokenTypeWithFlags, boolean putTokenInLC) {
        block60: {
            Object object;
            int tokenType = DwTokenHelper$.MODULE$.getTokenType(tokenTypeWithFlags);
            boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
            int n = tokenType;
            if (DwTokenType$.MODULE$.Key() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                long[] token = this.createKeyToken(nameStr, nameIndex, DwTokenHelper$.MODULE$.NO_NAMESPACE(), DwTokenType$.MODULE$.Key());
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                int nsIndex = this.dataInputStream().readUnsignedShort();
                long[] token = this.createKeyToken(nameStr, nameIndex, nsIndex, DwTokenType$.MODULE$.KeyWithNS());
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                long[] token = this.createKeyToken(nameStr, nameIndex, DwTokenHelper$.MODULE$.NO_NAMESPACE(), DwTokenType$.MODULE$.KeyWithAttr());
                this.addToken(token, putTokenInLC);
                this.readAttributes();
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                int nsIndex = this.dataInputStream().readUnsignedShort();
                long[] token = this.createKeyToken(nameStr, nameIndex, nsIndex, DwTokenType$.MODULE$.KeyWithNSAttr());
                this.addToken(token, putTokenInLC);
                this.readAttributes();
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.String8() == n) {
                int length = this.dataInputStream().read();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                byte[] readBuffer = this.getReadBuffer(length);
                object = BinaryValueRetriever$.MODULE$.readString(this.dataInputStream(), length, readBuffer);
            } else if (DwTokenType$.MODULE$.String32() == n) {
                int length = this.dataInputStream().readInt();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BinaryValueRetriever$.MODULE$.readString(this.dataInputStream(), length, this.getReadBuffer(length));
            } else if (DwTokenType$.MODULE$.Null() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.True() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.False() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Int() == n) {
                long[] token = this.createValueToken(4L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(4);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Long() == n) {
                long[] token = this.createValueToken(8L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(8);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.BigInt() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Double() == n) {
                long[] token = this.createValueToken(8L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(8);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
                BoxedUnit boxedUnit;
                long[] startToken = this.createValueToken(0L, tokenType, false);
                long startTokenIndex = this.tokenArray().length();
                this.addToken(startToken, putTokenInLC);
                int structureEndToken = this.readObject();
                hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(structureEndToken);
                if (hasSchema) {
                    long startOffset = DwTokenHelper$.MODULE$.getOffset(startToken);
                    long length = this.seekableStream().position() - startOffset;
                    long[] newStartToken = WeaveValueToken$.MODULE$.apply(startOffset, DwTokenType$.MODULE$.ObjectStart(), this.depth(), length, hasSchema);
                    this.tokenArray().update(startTokenIndex, newStartToken);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
            } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
                BoxedUnit boxedUnit;
                long[] startToken = this.createValueToken(0L, tokenType, false);
                long startTokenIndex = this.tokenArray().length();
                this.addToken(startToken, putTokenInLC);
                int structureEndToken = this.readArray();
                hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(structureEndToken);
                if (hasSchema) {
                    long startOffset = DwTokenHelper$.MODULE$.getOffset(startToken);
                    long length = this.seekableStream().position() - startOffset;
                    long[] newStartToken = WeaveValueToken$.MODULE$.apply(startOffset, DwTokenType$.MODULE$.ArrayStart(), this.depth(), length, hasSchema);
                    this.tokenArray().update(startTokenIndex, newStartToken);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
            } else if (DwTokenType$.MODULE$.Binary() == n) {
                int length = this.dataInputStream().readInt();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
                this.readNSDeclaration();
                this.processValue(this.readTokenType(), putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DeclareName() == n) {
                this.readNameDeclaration();
                this.processValue(this.readTokenType(), putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DateTime() == n) {
                int length = 20;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
                int length = 12;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalDate() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Time() == n) {
                int length = 16;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalTime() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.TimeZone() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Period() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Range() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Regex() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else {
                throw new DWBRuntimeExecutionException(new StringBuilder(24).append("Unexpected value type '").append(DwTokenType$.MODULE$.getNameFor(n)).append("'").toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!hasSchema) break block60;
            this.readSchema();
        }
    }

    private long[] createKeyToken(String name, int nameIndex, int nsIndex, int tokenType) {
        int length = WeaveBinaryUtils$.MODULE$.getUTFByteLength(name);
        int nameHash = DwTokenHelper$.MODULE$.hash(name);
        return WeaveKeyToken$.MODULE$.apply(this.seekableStream().position(), tokenType, this.depth(), length, nameHash, nameIndex, nsIndex);
    }

    private long[] createValueToken(long length, int tokenType, boolean hasSchema) {
        return WeaveValueToken$.MODULE$.apply(this.seekableStream().position(), tokenType, this.depth(), length, hasSchema);
    }

    public int readTokenType() {
        return this.dataInputStream().read();
    }

    private void readAttributes() {
        int attrCount = this.dataInputStream().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.readTokenType();
            this.processValue(nextValueType, false);
            this.processValue(this.readTokenType(), false);
        }
    }

    public void readSchema() {
        int propCount = this.dataInputStream().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.dataInputStream().read();
            this.processValue(nextKeyValueType, false);
            this.processValue(this.dataInputStream().read(), false);
        }
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    /*
     * WARNING - void declaration
     */
    private int readArray() {
        void var1_1;
        this.depth_$eq(this.depth() + 1);
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            this.processValue(tokenTypeWithFlags, true);
            tokenTypeWithFlags = this.readTokenType();
        }
        this.depth_$eq(this.depth() - 1);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int readObject() {
        void var1_1;
        this.depth_$eq(this.depth() + 1);
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            this.processValue(tokenTypeWithFlags, true);
            this.processValue(this.readTokenType(), false);
            tokenTypeWithFlags = this.readTokenType();
        }
        this.depth_$eq(this.depth() - 1);
        return (int)var1_1;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.dataInputStream(), this.getReadBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    public Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private void skipBytes(int n) {
        for (int i = 0; i < n; ++i) {
            this.dataInputStream().read();
        }
    }

    public void readCaches() {
        if (this.tokenArray() != null) {
            return;
        }
        long size = this.seekableStream().size();
        this.seekableStream().seek(size - 32L);
        int namesIndexBytes = this.dataInputStream().readInt();
        int namesIndexCount = this.dataInputStream().readInt();
        int nsIndexBytes = this.dataInputStream().readInt();
        int nsIndexCount = this.dataInputStream().readInt();
        long tokensLongsCount = this.dataInputStream().readLong();
        long lcIndexLength = this.dataInputStream().readLong();
        long offset = size - 32L - (long)namesIndexBytes - (long)nsIndexBytes - tokensLongsCount * 8L - lcIndexLength;
        this.seekableStream().seek(offset);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), namesIndexCount).foreach((Function1 & Serializable & scala.Serializable)_ -> IndexedWeaveBinaryParser.$anonfun$readCaches$1(this, BoxesRunTime.unboxToInt((Object)_)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nsIndexCount).foreach((Function1 & Serializable & scala.Serializable)_ -> IndexedWeaveBinaryParser.$anonfun$readCaches$2(this, BoxesRunTime.unboxToInt((Object)_)));
        this.tokenArray_$eq((TokenArray)this.ctx.registerCloseable((AutoCloseable)this.readGlobalTokenIndex(tokensLongsCount)));
        this.locationCaches_$eq((LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.readLocationCaches()));
        this.seekableStream().seek((long)WeaveBinaryWriter$.MODULE$.HEADER_BYTES());
    }

    /*
     * WARNING - void declaration
     */
    public TokenArray readGlobalTokenIndex(long tokensLongsCount) {
        void var3_2;
        TokenArray tokenArray = new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), this.ctx);
        int i = 0;
        long[] token = new long[2];
        while ((long)i < tokensLongsCount / 2L) {
            long firstLong = this.dataInputStream().readLong();
            long secondLong = this.dataInputStream().readLong();
            token[0] = firstLong;
            token[1] = secondLong;
            tokenArray.$plus$eq(token);
            ++i;
        }
        return var3_2;
    }

    public LocationCaches readLocationCaches() {
        int lcsLength = this.dataInputStream().readUnsignedShort();
        ILongArray[] lcs = new ILongArray[lcsLength];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lcsLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)depth -> {
            DefaultLongArray lc = new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1(), $this.ctx);
            long lcLength = this.dataInputStream().readLong();
            for (long entryIndex = 0L; entryIndex < lcLength; ++entryIndex) {
                lc.$plus$eq(this.dataInputStream().readLong());
            }
            lcs$1[depth] = lc;
        });
        return new LocationCaches(lcs);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readCaches$1(IndexedWeaveBinaryParser $this, int _) {
        int length = $this.dataInputStream().readUnsignedShort();
        String name = BinaryValueRetriever$.MODULE$.readString($this.dataInputStream(), length, $this.getReadBuffer(length));
        return $this.names().$plus$eq((Object)name);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readCaches$2(IndexedWeaveBinaryParser $this, int _) {
        int length = $this.dataInputStream().readUnsignedShort();
        String prefixUriStr = BinaryValueRetriever$.MODULE$.readString($this.dataInputStream(), length, $this.getReadBuffer(length));
        int index = prefixUriStr.indexOf(":");
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(prefixUriStr)).splitAt(index);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        return $this.namespaces().$plus$eq((Object)new Namespace(prefix2, uri2.substring(1)));
    }

    public IndexedWeaveBinaryParser(String name, SeekableStream ss, EvaluationContext ctx) {
        this.name = name;
        this.ss = ss;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.seekableStream = ss.spinOff(ctx);
        this.charset = Charset.forName("UTF-8");
        this.dataInputStream = new DataInputStream((InputStream)this.seekableStream());
        this.sourceReader = SeekableStreamSourceReader$.MODULE$.apply(this.seekableStream(), this.charset(), ctx.serviceManager().memoryService());
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new ZoneIdMap(this.names());
        this.zoneOffsets = new ZoneOffsetMap(this.names());
        this.lcBuilder = new LocationCacheBuilder((TokenHelper)DwTokenHelper$.MODULE$, ctx);
        this.depth = 0;
    }
}

