package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.ZoneId

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.TimeZoneValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryTimeZone(token: Array[Long], input: BinaryParserInput) extends TimeZoneValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: ZoneId = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val zoneIdIndex = stream.readUnsignedShort()
    input.zoneIds.get(zoneIdIndex)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
